<?php

/*
 * @copyright  Copyright (c) 2013 by  ESS-UA.
 */

class Ess_M2ePro_Block_Adminhtml_Common_Play_Order_View extends Mage_Adminhtml_Block_Widget_Form_Container
{
    public function __construct()
    {
        parent::__construct();

        // Initialization block
        //------------------------------
        $this->setId('playOrderView');
        $this->_blockGroup = 'M2ePro';
        $this->_controller = 'adminhtml_common_play_order';
        $this->_mode = 'view';
        //------------------------------

        // Set header text
        //------------------------------
        $this->_headerText = Mage::helper('M2ePro')->__('View Order Details');
        //------------------------------

        /** @var $order Ess_M2ePro_Model_Order */
        $this->order = Mage::helper('M2ePro/Data_Global')->getValue('temp_data');

        // Set buttons actions
        //------------------------------
        $this->removeButton('back');
        $this->removeButton('reset');
        $this->removeButton('delete');
        $this->removeButton('add');
        $this->removeButton('save');
        $this->removeButton('edit');
        //------------------------------

        //------------------------------
        $url = Mage::helper('M2ePro')->getBackUrl('*/adminhtml_common_order/index');
        $this->_addButton('back', array(
            'label'     => Mage::helper('M2ePro')->__('Back'),
            'onclick'   => 'CommonHandlerObj.back_click(\''.$url.'\')',
            'class'     => 'back'
        ));
        //------------------------------

        if ($this->order->getReserve()->isPlaced()) {
            //------------------------------
            $url = $this->getUrl('*/adminhtml_order/reservationCancel', array('ids' => $this->order->getId()));
            $this->_addButton('reservation_cancel', array(
                'label'     => Mage::helper('M2ePro')->__('Cancel Qty Reserve'),
                'onclick'   => "confirmSetLocation(M2ePro.translator.translate('Are you sure?'), '".$url."');",
                'class'     => 'scalable'
            ));
            //------------------------------
        } else if (is_null($this->order->getMagentoOrderId())) {
            //------------------------------
            $url = $this->getUrl('*/adminhtml_order/reservationPlace', array('ids' => $this->order->getId()));
            $this->_addButton('reservation_place', array(
                'label'     => Mage::helper('M2ePro')->__('Reserve Qty'),
                'onclick'   => "confirmSetLocation(M2ePro.translator.translate('Are you sure?'), '".$url."');",
                'class'     => 'scalable'
            ));
            //------------------------------
        }

        if (is_null($this->order->getMagentoOrderId())) {
            //------------------------------
            $url = $this->getUrl('*/*/createMagentoOrder', array('id' => $this->order->getId()));
            $this->_addButton('order', array(
                'label'     => Mage::helper('M2ePro')->__('Create Order'),
                'onclick'   => "setLocation('".$url."');",
                'class'     => 'scalable'
            ));
            //------------------------------
        } else if (is_null($this->order->getMagentoOrder()) || $this->order->getMagentoOrder()->isCanceled()) {
            //------------------------------
            $url = $this->getUrl('*/*/createMagentoOrder', array('id' => $this->order->getId(), 'force' => 'yes'));
            $confirm = Mage::helper('M2ePro')->escapeJs(
                Mage::helper('M2ePro')->__('Are you sure that you want to create new Magento Order?')
            );
            $this->_addButton('order', array(
                'label'     => Mage::helper('M2ePro')->__('Create Order'),
                'onclick'   => "confirmSetLocation('".$confirm."','".$url."');",
                'class'     => 'scalable'
            ));
            //------------------------------
        }
    }
}